/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsObject;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.content.schema.facets.CardinalityFacet;
import jade.content.schema.facets.TypedAggregateFacet;
import jade.core.CaseInsensitiveString;
import jade.util.Logger;
import jade.util.leap.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ObjectSchemaImpl
extends ObjectSchema {
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private String typeName = null;
    private Hashtable slots;
    private Vector slotNames;
    private Vector superSchemas;
    private Hashtable facets;

    private ObjectSchemaImpl() {
        this("Object");
    }

    protected ObjectSchemaImpl(String typeName) {
        this.typeName = typeName;
    }

    protected void add(String name, ObjectSchema slotSchema, int optionality) {
        CaseInsensitiveString ciName = new CaseInsensitiveString(name);
        if (this.slots == null) {
            this.slots = new Hashtable();
            this.slotNames = new Vector();
        }
        if (this.slots.put(ciName, new SlotDescriptor(name, slotSchema, optionality)) == null) {
            this.slotNames.addElement(ciName);
        }
    }

    protected void add(String name, ObjectSchema slotSchema) {
        this.add(name, slotSchema, 0);
    }

    protected void add(String name, ObjectSchema elementsSchema, int cardMin, int cardMax) {
        this.add(name, elementsSchema, cardMin, cardMax, "sequence");
    }

    protected void add(String name, ObjectSchema elementsSchema, int cardMin, int cardMax, String aggType) {
        int optionality = cardMin == 0 ? 1 : 0;
        try {
            this.add(name, BasicOntology.getInstance().getSchema(aggType), optionality);
            this.addFacet(name, new TypedAggregateFacet(elementsSchema));
            this.addFacet(name, new CardinalityFacet(cardMin, cardMax));
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    protected void addSuperSchema(ObjectSchema superSchema) {
        if (this.superSchemas == null) {
            this.superSchemas = new Vector();
        }
        this.superSchemas.addElement(superSchema);
    }

    protected void addFacet(String slotName, Facet f) throws OntologyException {
        Vector<Facet> v;
        if (this.containsSlot(slotName)) {
            CaseInsensitiveString ciName = new CaseInsensitiveString(slotName);
            if (this.facets == null) {
                this.facets = new Hashtable();
            }
            if ((v = (Vector<Facet>)this.facets.get(ciName)) == null) {
                v = new Vector<Facet>();
                this.facets.put(ciName, v);
                if (this.logger.isLoggable(7)) {
                    this.logger.log(7, "Added facet " + f + " to slot " + slotName);
                }
            }
        } else {
            throw new OntologyException(slotName + " is not a valid slot in this schema");
        }
        v.addElement(f);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getNames() {
        Vector allSlotNames = new Vector();
        this.fillAllSlotNames(allSlotNames);
        String[] names = new String[allSlotNames.size()];
        int counter = 0;
        Enumeration e = allSlotNames.elements();
        while (e.hasMoreElements()) {
            names[counter++] = ((CaseInsensitiveString)e.nextElement()).toString();
        }
        return names;
    }

    public ObjectSchema getSchema(String name) throws OntologyException {
        SlotDescriptor slot = this.getSlot(new CaseInsensitiveString(name));
        if (slot == null) {
            throw new OntologyException("No slot named: " + name);
        }
        return slot.schema;
    }

    public boolean containsSlot(String name) {
        SlotDescriptor slot = this.getSlot(new CaseInsensitiveString(name));
        return slot != null;
    }

    public boolean isMandatory(String name) throws OntologyException {
        SlotDescriptor slot = this.getSlot(new CaseInsensitiveString(name));
        if (slot == null) {
            throw new OntologyException("No slot named: " + name);
        }
        return slot.optionality == 0;
    }

    public AbsObject newInstance() throws OntologyException {
        throw new OntologyException("AbsObject cannot be instantiated");
    }

    private final void fillAllSlotNames(Vector v) {
        Enumeration e;
        if (this.superSchemas != null) {
            e = this.superSchemas.elements();
            while (e.hasMoreElements()) {
                ObjectSchemaImpl superSchema = (ObjectSchemaImpl)e.nextElement();
                superSchema.fillAllSlotNames(v);
            }
        }
        if (this.slotNames != null) {
            e = this.slotNames.elements();
            while (e.hasMoreElements()) {
                v.addElement(e.nextElement());
            }
        }
    }

    public void validate(AbsObject abs, Ontology onto) throws OntologyException {
        this.validateSlots(abs, onto);
    }

    protected void validateSlots(AbsObject abs, Ontology onto) throws OntologyException {
        String[] slotNames = this.getNames();
        int i = 0;
        while (i < slotNames.length) {
            AbsObject slotValue = abs.getAbsObject(slotNames[i]);
            CaseInsensitiveString ciName = new CaseInsensitiveString(slotNames[i]);
            this.validate(ciName, slotValue, onto);
            ++i;
        }
    }

    private boolean validate(CaseInsensitiveString slotName, AbsObject value, Ontology onto) throws OntologyException {
        if (this.logger.isLoggable(5)) {
            this.logger.log(5, "Validating " + (value != null ? value.toString() : "null") + " as a value for slot " + slotName);
        }
        boolean slotFound = false;
        SlotDescriptor dsc = this.getOwnSlot(slotName);
        if (dsc != null) {
            if (this.logger.isLoggable(7)) {
                this.logger.log(7, "Slot " + slotName + " is defined in schema " + this);
            }
            if (value == null) {
                if (dsc.optionality == 0) {
                    throw new OntologyException("Missing value for mandatory slot " + slotName + ". Schema is " + this);
                }
                return true;
            }
            ObjectSchema s = onto.getSchema(value.getTypeName());
            if (this.logger.isLoggable(7)) {
                this.logger.log(7, "Actual schema for " + value + " is " + s);
            }
            if (s == null) {
                throw new OntologyException("No schema found for type " + value.getTypeName());
            }
            if (!s.isCompatibleWith(dsc.schema)) {
                throw new OntologyException("Schema " + s + " for element " + value + " is not compatible with schema " + dsc.schema + " for slot " + slotName);
            }
            if (this.logger.isLoggable(7)) {
                this.logger.log(7, "Schema " + s + " for type " + value + " is compatible with schema " + dsc.schema + " for slot " + slotName);
            }
            s.validate(value, onto);
            slotFound = true;
        } else if (this.superSchemas != null) {
            Enumeration e = this.superSchemas.elements();
            while (e.hasMoreElements()) {
                ObjectSchemaImpl s = (ObjectSchemaImpl)e.nextElement();
                if (!s.validate(slotName, value, onto)) continue;
                slotFound = true;
                break;
            }
        }
        if (slotFound && this.facets != null) {
            Vector ff = (Vector)this.facets.get(slotName);
            if (ff != null) {
                Enumeration e = ff.elements();
                while (e.hasMoreElements()) {
                    Facet f = (Facet)e.nextElement();
                    if (this.logger.isLoggable(7)) {
                        this.logger.log(7, "Checking facet " + f + " defined on slot " + slotName);
                    }
                    f.validate(value, onto);
                }
            } else if (this.logger.isLoggable(7)) {
                this.logger.log(7, "No facets for slot " + slotName);
            }
        }
        return slotFound;
    }

    public boolean isCompatibleWith(ObjectSchema s) {
        if (this.equals(s)) {
            return true;
        }
        if (this.isSubSchemaOf(s)) {
            return true;
        }
        return this.descendsFrom(s);
    }

    protected boolean descendsFrom(ObjectSchema s) {
        if (s != null) {
            return s.equals(ObjectSchema.getBaseSchema());
        }
        return false;
    }

    private boolean isSubSchemaOf(ObjectSchema s) {
        if (this.superSchemas != null) {
            Enumeration e = this.superSchemas.elements();
            while (e.hasMoreElements()) {
                ObjectSchemaImpl s1 = (ObjectSchemaImpl)e.nextElement();
                if (s1.equals(s)) {
                    return true;
                }
                if (!s1.isSubSchemaOf(s)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "-" + this.getTypeName();
    }

    public boolean equals(Object o) {
        if (o != null) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public Facet[] getFacets(String slotName) {
        Facet[] temp;
        block4: {
            block3: {
                Vector v;
                temp = null;
                CaseInsensitiveString caseInsensitiveSlotName = new CaseInsensitiveString(slotName);
                if (this.getOwnSlot(caseInsensitiveSlotName) == null) break block3;
                if (this.facets == null || (v = (Vector)this.facets.get(caseInsensitiveSlotName)) == null) break block4;
                temp = new Facet[v.size()];
                int i = 0;
                while (i < v.size()) {
                    temp[i] = (Facet)v.elementAt(i);
                    ++i;
                }
                break block4;
            }
            if (this.superSchemas != null) {
                int i = 0;
                while (i < this.superSchemas.size() && temp == null) {
                    temp = ((ObjectSchema)this.superSchemas.elementAt(i)).getFacets(slotName);
                    ++i;
                }
            }
        }
        return temp;
    }

    private final SlotDescriptor getOwnSlot(CaseInsensitiveString ciName) {
        return this.slots != null ? (SlotDescriptor)this.slots.get(ciName) : null;
    }

    private final SlotDescriptor getSlot(CaseInsensitiveString ciName) {
        SlotDescriptor dsc = this.getOwnSlot(ciName);
        if (dsc == null && this.superSchemas != null) {
            int i = 0;
            while (i < this.superSchemas.size()) {
                ObjectSchemaImpl sc = (ObjectSchemaImpl)this.superSchemas.elementAt(i);
                dsc = sc.getSlot(ciName);
                if (dsc != null) break;
                ++i;
            }
        }
        return dsc;
    }

    static {
        ObjectSchema.baseSchema = new ObjectSchemaImpl();
    }

    private class SlotDescriptor
    implements Serializable {
        private String name = null;
        private ObjectSchema schema = null;
        private int optionality = 0;

        private SlotDescriptor(String name, ObjectSchema schema, int optionality) {
            this.name = name;
            this.schema = schema;
            this.optionality = optionality;
        }
    }
}

